/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.block;

import java.util.Random;
import net.jayjay.dangerzone.block.Block;
import net.jayjay.dangerzone.block.Blocks;
import net.jayjay.dangerzone.world.World;

public class BlockLeaves
extends Block {
    protected BlockLeaves(String tag, int tex) {
        super(tag, tex);
        this.breaksound = "dz2:shatter";
        this.material = "dz2:material_plant";
    }

    @Override
    public boolean blocksLight() {
        return false;
    }

    @Override
    public int getCullingMode() {
        return 0;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public void tick(World level, int x, int y, int z, Random random) {
        if (!this.isNearLog(level, x, y, z)) {
            this.decay(level, x, y, z, random);
        }
    }

    private boolean isNearLog(World level, int x, int y, int z) {
        int dx = -6;
        while (dx <= 6) {
            int dy = -6;
            while (dy <= 6) {
                int dz = -6;
                while (dz <= 6) {
                    int blockId;
                    if (Math.abs(dx) + Math.abs(dy) + Math.abs(dz) <= 6 && ((blockId = level.getBlock(x + dx, y + dy, z + dz)) == Blocks.getBlockID("dz2:oak_log") || blockId == Blocks.getBlockID("dz2:super_log"))) {
                        return true;
                    }
                    ++dz;
                }
                ++dy;
            }
            ++dx;
        }
        return false;
    }

    private void decay(World level, int x, int y, int z, Random random) {
        level.setBlock(x, y, z, 0);
    }
}

